// Responses should always correspond to the protocol definitions at
// https://github.com/decentraland/protocol/blob/main/proto/decentraland/kernel/apis/runtime.proto

module.exports.getRealm = async function (message) {
    return await UnityRuntime.GetRealm();
}

module.exports.getWorldTime = async function (message) {
    return await UnityRuntime.GetWorldTime();
}

module.exports.readFile = async function (message) {
    return await UnityRuntime.ReadFile(message.fileName)
}

module.exports.getSceneInformation = function (message) {
    const result = UnityRuntime.GetSceneInformation()
    
    const content = JSON.parse(result.contentJson)
    
    return {
        urn: result.urn,
        content: content,
        metadataJson: result.metadataJson,
        baseUrl: result.baseUrl
    }
}

module.exports.getExplorerInformation = async function (body) {
    return {
        agent: 'unity-explorer',
        platform: 'desktop',
        configurations: {}
    }
}